//=============================================================================
// LMSScoreBoard
//=============================================================================
class LMSSB extends DMSB config(PaleridersHUD_SB);

//var localized string VictoryGoal;
var config string VictoryGoal, PlayerString, FragString, LivesString;
var config byte bLMSAdminColorR, bLMSAdminColorG, bLMSAdminColorB, bLMSLocalColorR, bLMSLocalColorG, bLMSLocalColorB, bLMSPColorR, bLMSPColorG, bLMSPColorB;
var config byte bLMSVictoryColorR, bLMSVictoryColorG, bLMSVictoryColorB;
var config byte bLMSOutColorR, bLMSOutColorG, bLMSOutColorB, bLMSInColorR, bLMSInColorG, bLMSInColorB;
var config byte bLMSPstringColorR, bLMSPstringColorG, bLMSPstringColorB;
var config byte bLMSLstringColorR, bLMSLstringColorG, bLMSLstringColorB;


function DrawCategoryHeaders(Canvas Canvas)
{
	local float Offset, XL, YL;

// Player Nick

	Offset = Canvas.CurY;
	Canvas.DrawColor.R = bLMSPstringColorR;
	Canvas.DrawColor.G = bLMSPstringColorG;
	Canvas.DrawColor.B = bLMSPstringColorB;

	Canvas.StrLen(PlayerString, XL, YL);
	Canvas.SetPos((Canvas.ClipX / 8)*2 - XL/2, Offset);
	Canvas.DrawText(PlayerString);


// Lives left
	Canvas.DrawColor.R = bLMSLstringColorR;
	Canvas.DrawColor.G = bLMSLstringColorG;
	Canvas.DrawColor.B = bLMSLstringColorB;

	Canvas.StrLen(FragsString, XL, YL);
	Canvas.SetPos((Canvas.ClipX / 8)*6 - XL/2, Offset);
	Canvas.DrawText(LivesString);

	if (Level.NetMode != NM_StandAlone)
	{
		Canvas.StrLen(PingString, XL, YL);
		Canvas.SetPos((Canvas.ClipX / 8)*7 - XL/2, Offset);
		Canvas.DrawText(PingString);
	}
}

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
	local float XL, YL, XL2;
	local Font CanvasFont;
	local bool bLocalPlayer;
	local PlayerPawn PlayerOwner;
	PlayerOwner = PlayerPawn(Owner);
	bLocalPlayer = (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);


	// Draw Name
	if ( PRI.bAdmin )
		{
		Canvas.DrawColor.R = bLMSAdminColorR;
		Canvas.DrawColor.G = bLMSAdminColorG;
		Canvas.DrawColor.B = bLMSAdminColorB;
		}
	else if ( bLocalPlayer )
		{
		Canvas.DrawColor.R = bLMSLocalColorR;
		Canvas.DrawColor.G = bLMSLocalColorG;
		Canvas.DrawColor.B = bLMSLocalColorB;
		}
	else
		{
		Canvas.DrawColor.R = bLMSPColorR;
		Canvas.DrawColor.G = bLMSPColorG;
		Canvas.DrawColor.B = bLMSPColorB;
		}

	Canvas.SetPos((Canvas.ClipX / 8) * 1.5, YOffset);
	Canvas.DrawText(PRI.PlayerName, False);

	Canvas.StrLen( "0000", XL, YL );

	// Draw Score
	if ( PRI.Score < 1 )
		{
		Canvas.DrawColor.R = bLMSOutColorR;
		Canvas.DrawColor.G = bLMSOutColorG;
		Canvas.DrawColor.B = bLMSOutColorB;
		}
	else
		{
		Canvas.DrawColor.R = bLMSInColorR;
		Canvas.DrawColor.G = bLMSInColorG;
		Canvas.DrawColor.B = bLMSInColorB;
		}
	if ( bLocalPlayer )
		{
		Canvas.DrawColor.R = bLMSLocalColorR;
		Canvas.DrawColor.G = bLMSLocalColorG;
		Canvas.DrawColor.B = bLMSLocalColorB;
		}
	Canvas.StrLen( int(PRI.Score), XL2, YL );
	Canvas.SetPos( (Canvas.ClipX / 8) * 6 + XL/2 - XL2, YOffset );
	Canvas.DrawText( int(PRI.Score), false );

	if (Level.NetMode != NM_Standalone)
	{
		// Draw Ping
		Canvas.DrawColor = LightCyanColor;
		Canvas.StrLen( PRI.Ping, XL2, YL );
		Canvas.SetPos( (Canvas.ClipX / 8) * 7 + XL/2 - XL2, YOffset );
		Canvas.DrawText( PRI.Ping, false );
	}
}

function DrawVictoryConditions(Canvas Canvas)
{
	Canvas.DrawColor.R = bLMSVictoryColorR;
	Canvas.DrawColor.G = bLMSVictoryColorG;
	Canvas.DrawColor.B = bLMSVictoryColorB;
	Canvas.DrawText(VictoryGoal);
}

defaultproperties
{
//     VictoryGoal="Be the last one alive!"
//     FragsString="Lives"
}
